#include "bdtypes.h"
#include "bdfunc.h"
#include "bdglobal.h"
#include "generator.h"

Obj3d* GenerateTorus(DWORD faces_big, DWORD faces_little,
					 float rayon_big, float rayon_little)
{
	DWORD Cpt3;
	Obj3d* pObj;
	float Rayon;
	unsigned int Cpt1, Cpt2;
	unsigned int A, B, C, D;

	pObj = (Obj3d*)malloc(sizeof(Obj3d));

	pObj->NbVertex = faces_big * faces_little;
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<faces_big;Cpt1++) // hauteur
	{
		for(Cpt2=0;Cpt2<faces_little;Cpt2++) // rayon
		{
			Rayon = rayon_big + rayon_little * (float)sin(Cpt2%(faces_little-1) * PI2 / (faces_little-1)) +
					rayon_little * (float)sin(Cpt2%(faces_little-1) * PI2 *4.f / (faces_little-1)) / 5.f +
					rayon_little * (float)sin(Cpt1%(faces_big-1) * PI2 *16.f / (faces_big-1)) / 5.f;
			pObj->pVertexIn[Cpt3].x = Rayon * (float)cos(Cpt1%(faces_big-1) * PI2 / (faces_big-1));
			pObj->pVertexIn[Cpt3].y = rayon_little * (float)cos(Cpt2%(faces_little-1) * PI2 / (faces_little-1));
			pObj->pVertexIn[Cpt3].z = Rayon * (float)sin(Cpt1%(faces_big-1) * PI2 / (faces_big-1));
			pObj->pVertexIn[Cpt3].oow = pObj->pVertexIn[Cpt3].y * pObj->pVertexIn[Cpt3].z;
			pObj->pVertexIn[Cpt3].tmuvtx[0].sow = Cpt2 * 512.f/ (faces_little-1);
			pObj->pVertexIn[Cpt3].tmuvtx[0].tow = Cpt1 * 4096.f/ (faces_big-1);
			pObj->pVertexOut[Cpt3].r = 128.f + 127 * (float)sin(Cpt1%(faces_big-1) * PI2 *16.f / (faces_big-1));
			pObj->pVertexOut[Cpt3].g = 128.f + 127 * (float)cos(Cpt1%(faces_big-1) * PI2 *16.f / (faces_big-1));
			pObj->pVertexOut[Cpt3].b = 128.f + 127 * (float)sin(Cpt2%(faces_little-1) * PI2 *16.f / (faces_little-1));
			pObj->pVertexOut[Cpt3].a = (pObj->pVertexIn[Cpt3].r + pObj->pVertexIn[Cpt3].g + pObj->pVertexIn[Cpt3].b) / 3.f;
			Cpt3++;
		}
	}

	pObj->NbFaces = (faces_big-1) * (faces_little-1) * 2;
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<(faces_big-1);Cpt1++) // hauteur
	{
		for(Cpt2=0;Cpt2<(faces_little-1);Cpt2++) // cercle
		{
			A = Cpt2 + faces_little * Cpt1;
			B = Cpt2 + 1 + faces_little * Cpt1;
			C = Cpt2 + 1 + faces_little * (Cpt1+1);
			D = Cpt2 + faces_little * (Cpt1+1);

			pObj->pFace[Cpt3].A = A;
			pObj->pFace[Cpt3].B = B;
			pObj->pFace[Cpt3].C = C;

			Cpt3++;

			pObj->pFace[Cpt3].A = C;
			pObj->pFace[Cpt3].B = D;
			pObj->pFace[Cpt3].C = A;

			Cpt3++;
		}
	}

	return pObj;
}


Obj3d* GenerateSphere(DWORD radius_faces, DWORD height_faces,
					 float radius_dst, float height_dst, float sow, float tow)
{
	DWORD Cpt1, Cpt2, Cpt3;
	Obj3d* pObj;
	float y, Rayon;
	unsigned int A, B, C, D;
		
	pObj = (Obj3d*)malloc(sizeof(Obj3d));

	pObj->NbVertex = (radius_faces+1) * (height_faces+1);
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);

	Cpt3 = 0;

	y = 0 - height_dst;
	Rayon;

	for(Cpt1=0;Cpt1 < height_faces+1;Cpt1++)
	{
		for(Cpt2=0;Cpt2 < radius_faces+1;Cpt2++)
		{
			pObj->pVertexIn[Cpt3].y = y;
			Rayon = (float)sqrt(radius_dst*radius_dst-y*y);
			pObj->pVertexIn[Cpt3].x = Rayon*(float)cos(Cpt2*PI2/radius_faces);
			pObj->pVertexIn[Cpt3].z = Rayon*(float)sin(Cpt2*PI2/radius_faces);
			pObj->pVertexIn[Cpt3].tmuvtx[0].sow = (float)Cpt2*sow/radius_faces;
			pObj->pVertexIn[Cpt3].tmuvtx[0].tow = (float)Cpt1*tow/height_faces;

			pObj->pVertexOut[Cpt3].r = (float)sin((float)Cpt1/(height_faces+1)*PI)*255;
			pObj->pVertexOut[Cpt3].g = pObj->pVertexOut[Cpt3].r;
			pObj->pVertexOut[Cpt3].b = pObj->pVertexOut[Cpt3].r;

			Cpt3++;
		}
		//y += height_dst*2.f/height_faces;
		y = (float)cos(Cpt1*PI/(height_faces-1))*height_dst;	
	}	


	pObj->NbFaces = radius_faces * height_faces * 2;
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);

	Cpt3 =0;

	for(Cpt1=0;Cpt1<height_faces;Cpt1++)
	{
		for(Cpt2=0;Cpt2<radius_faces;Cpt2++)
		{
			A =	Cpt2 + Cpt1 * (radius_faces+1);
			B =	Cpt2 + 1 + Cpt1 * (radius_faces+1);
			C =	Cpt2 + 1 + (Cpt1+1) * (radius_faces+1);
			D =	Cpt2 + (Cpt1+1) * (radius_faces+1);

			pObj->pFace[Cpt3].A = A;
			pObj->pFace[Cpt3].B = B;
			pObj->pFace[Cpt3].C = C;

			Cpt3++;

			pObj->pFace[Cpt3].A = C;
			pObj->pFace[Cpt3].B = D;
			pObj->pFace[Cpt3].C = A;

			Cpt3++;
		}
	}

	return pObj;
}


Obj3d* GenerateFloor(DWORD width_faces, DWORD height_faces,
					 float width_dst, float height_dst, float sow, float tow)
{
	DWORD Cpt3;
	Obj3d* pObj = (Obj3d*)malloc(sizeof(Obj3d));
	float x, y;
	unsigned int Cpt1, Cpt2;
	unsigned int A, B, C, D;

	pObj->NbVertex = (width_faces+1) * (height_faces+1);
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);

	x = -width_dst;
	y = 0-height_dst;
	Cpt3 = 0;

	for(Cpt1=0;Cpt1 < height_faces+1;Cpt1++)
	{
		for(Cpt2=0;Cpt2 < width_faces+1;Cpt2++)
		{
			pObj->pVertexIn[Cpt3].x = x;
			pObj->pVertexIn[Cpt3].y = y;
			pObj->pVertexIn[Cpt3].z = 0.f;
			pObj->pVertexIn[Cpt3].tmuvtx[0].sow = (float)Cpt2*sow/(float)width_faces;
			pObj->pVertexIn[Cpt3].tmuvtx[0].tow = (float)Cpt1*tow/(float)height_faces;
			pObj->pVertexIn[Cpt3].r = 0;
			pObj->pVertexIn[Cpt3].g = 0;
			pObj->pVertexIn[Cpt3].b = 0;

			x += width_dst*2.f/width_faces;
			Cpt3++;
		}
		x = 0-width_dst;
		y += height_dst*2.f/height_faces;
	}

	pObj->NbFaces = width_faces  * height_faces * 2;
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);

	Cpt3 =0;
	for(Cpt1=0;Cpt1<height_faces;Cpt1++)
	{
		for(Cpt2=0;Cpt2<width_faces;Cpt2++)
		{
			A =	Cpt2 + Cpt1 * (width_faces+1);
			B =	Cpt2 + 1 + Cpt1 * (width_faces+1);
			C =	Cpt2 + 1 + (Cpt1+1) * (width_faces+1);
			D =	Cpt2 + (Cpt1+1) * (width_faces+1);

			pObj->pFace[Cpt3].A = A;
			pObj->pFace[Cpt3].B = B;
			pObj->pFace[Cpt3].C = C;

			Cpt3++;

			pObj->pFace[Cpt3].A = C;
			pObj->pFace[Cpt3].B = D;
			pObj->pFace[Cpt3].C = A;

			Cpt3++;
		}
	}	

	return pObj;
}

Obj3d* GenerateCylinder(DWORD radius_faces, DWORD height_faces,
					 float radius_dst, float height_dst, float sow, float tow)
{
	DWORD Cpt1, Cpt2, Cpt3;
	Obj3d* pObj;
	unsigned int A, B, C, D;

	pObj = (Obj3d*)malloc(sizeof(Obj3d));

	pObj->NbVertex = (radius_faces+1) * (height_faces+1);
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<height_faces;Cpt1++) // hauteur
	{
		for(Cpt2=0;Cpt2<radius_faces;Cpt2++) // rayon
		{

			pObj->pVertexIn[Cpt3].x = radius_dst * (float)cos(Cpt2%(radius_faces-1) * PI2 / (radius_faces-1));
			pObj->pVertexIn[Cpt3].y = height_dst * (Cpt1/(float)(height_faces-1)-0.5f)*2;
			pObj->pVertexIn[Cpt3].z = radius_dst * (float)sin(Cpt2%(radius_faces-1) * PI2 / (radius_faces-1));
			pObj->pVertexIn[Cpt3].oow = pObj->pVertexIn[Cpt3].y * pObj->pVertexIn[Cpt3].z;
			pObj->pVertexIn[Cpt3].tmuvtx[0].sow = Cpt1 * tow/ (height_faces-1);
			pObj->pVertexIn[Cpt3].tmuvtx[0].tow = Cpt2 * sow/ (radius_faces-1);
			pObj->pVertexOut[Cpt3].r = 128.f + 127 * (float)sin(Cpt1%(radius_faces-1) * PI2 *16.f / (radius_faces-1));
			pObj->pVertexOut[Cpt3].g = 128.f + 127 * (float)cos(Cpt1%(radius_faces-1) * PI2 *16.f / (radius_faces-1));
			pObj->pVertexOut[Cpt3].b = 128.f + 127 * (float)sin(Cpt2%(height_faces-1) * PI2 *16.f / (height_faces-1));
			pObj->pVertexOut[Cpt3].a = (pObj->pVertexIn[Cpt3].r + pObj->pVertexIn[Cpt3].g + pObj->pVertexIn[Cpt3].b) / 3.f;
			Cpt3++;
		}
	}

	pObj->NbFaces = (radius_faces-1) * (height_faces-1) * 2;
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<(height_faces-1);Cpt1++) // hauteur
	{
		for(Cpt2=0;Cpt2<(radius_faces-1);Cpt2++) // cercle
		{
			A = Cpt2 + radius_faces * Cpt1;
			B = Cpt2 + 1 + radius_faces * Cpt1;
			C = Cpt2 + 1 + radius_faces * (Cpt1+1);
			D = Cpt2 + radius_faces * (Cpt1+1);

			pObj->pFace[Cpt3].A = A;
			pObj->pFace[Cpt3].B = B;
			pObj->pFace[Cpt3].C = C;

			Cpt3++;

			pObj->pFace[Cpt3].A = C;
			pObj->pFace[Cpt3].B = D;
			pObj->pFace[Cpt3].C = A;

			Cpt3++;
		}
	}

	return pObj;
}

Obj3d* CopyObj(Obj3d* pObj)
{
	Obj3d *pResult;
	unsigned int Cpt1;

	pResult = (Obj3d*)malloc(sizeof(Obj3d));

	// alloc Vertex
	pResult->NbVertex = pObj->NbVertex;
	pResult->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pResult->NbVertex);
	pResult->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pResult->NbVertex);

	// alloc Face
	pResult->NbFaces = pObj->NbFaces;
	pResult->pFace = (Face*)malloc(sizeof(Face)*pResult->NbFaces);

	// copy vertex
	for(Cpt1=0;Cpt1<pObj->NbVertex;Cpt1++)
		pResult->pVertexIn[Cpt1] = pObj->pVertexIn[Cpt1];

	// copy faces
	for(Cpt1=0;Cpt1<pObj->NbFaces;Cpt1++)
		pResult->pFace[Cpt1] = pObj->pFace[Cpt1];

	return pResult;
}

Obj3d* CombineObj(Obj3d* pObj1, Obj3d* pObj2)
{
	Obj3d *pResult;
	unsigned int Cpt1;

	pResult = (Obj3d*)malloc(sizeof(Obj3d));
	
	// alloc Vertex
	pResult->NbVertex = pObj1->NbVertex + pObj2->NbVertex;
	pResult->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pResult->NbVertex);
	pResult->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pResult->NbVertex);

	// alloc Face
	pResult->NbFaces = pObj1->NbFaces + pObj2->NbFaces;
	pResult->pFace = (Face*)malloc(sizeof(Face)*pResult->NbFaces);

	// copy vertex
	//		Obj1
	for(Cpt1=0;Cpt1<pObj1->NbVertex;Cpt1++)
		pResult->pVertexIn[Cpt1] = pObj1->pVertexIn[Cpt1];
	//		Obj2
	for(Cpt1=0;Cpt1<pObj2->NbVertex;Cpt1++)
		pResult->pVertexIn[Cpt1+pObj1->NbVertex] = pObj2->pVertexIn[Cpt1];

	// copy faces
	//		Obj1
	for(Cpt1=0;Cpt1<pObj1->NbFaces;Cpt1++)
		pResult->pFace[Cpt1] = pObj1->pFace[Cpt1];
	//		Obj2
	for(Cpt1=0;Cpt1<pObj2->NbFaces;Cpt1++)
	{
		pResult->pFace[Cpt1+pObj1->NbFaces] = pObj2->pFace[Cpt1];
		pResult->pFace[Cpt1+pObj1->NbFaces].A += pObj1->NbVertex;
		pResult->pFace[Cpt1+pObj1->NbFaces].B += pObj1->NbVertex;
		pResult->pFace[Cpt1+pObj1->NbFaces].C += pObj1->NbVertex;
	}

	DeleteObj(pObj1);
	return pResult;
}

void DeleteObj(Obj3d *pObj)
{
	free(pObj->pVertexIn);
	free(pObj->pVertexOut);
	free(pObj->pFace);
	free(pObj);
}


Obj3d* GenerateCylinderSpecial(DWORD radius_faces, DWORD height_faces,
					 float radius_dst, float height_dst, float sow, float tow)
{
	DWORD Cpt1, Cpt2, Cpt3;
	unsigned int A, B, C, D;
	Obj3d* pObj;
	
	pObj = (Obj3d*)malloc(sizeof(Obj3d));

	pObj->NbVertex = (radius_faces+1) * (height_faces+1);
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<height_faces;Cpt1++) // hauteur
	{
		//float Ratio = (cos((float)Cpt1/height_faces*PI2)+1)/2+0.5f;
		float Ratio = (float)cos((float)Cpt1/(height_faces-1)*PI2)*1.5f+2.5f;
		for(Cpt2=0;Cpt2<radius_faces;Cpt2++) // rayon
		{
			pObj->pVertexIn[Cpt3].x = Ratio * radius_dst * (float)cos(Cpt2%(radius_faces-1) * PI2 / (radius_faces-1));
			pObj->pVertexIn[Cpt3].y = height_dst * (Cpt1/(float)(height_faces-1)-0.5f)*2;
			pObj->pVertexIn[Cpt3].z = Ratio * radius_dst * (float)sin(Cpt2%(radius_faces-1) * PI2 / (radius_faces-1));
			pObj->pVertexIn[Cpt3].oow = pObj->pVertexIn[Cpt3].y * pObj->pVertexIn[Cpt3].z;
			pObj->pVertexIn[Cpt3].tmuvtx[0].sow = Cpt1 * tow/ (height_faces-1);
			pObj->pVertexIn[Cpt3].tmuvtx[0].tow = Cpt2 * sow/ (radius_faces-1);
			pObj->pVertexOut[Cpt3].r = (float)cos((float)Cpt1/(height_faces+1)*PI2)*127+128;
			pObj->pVertexOut[Cpt3].r = 255;
			pObj->pVertexOut[Cpt3].g = pObj->pVertexOut[Cpt3].r;
			pObj->pVertexOut[Cpt3].b = pObj->pVertexOut[Cpt3].r;
			pObj->pVertexOut[Cpt3].a = 0;
			Cpt3++;
		}
	}

	pObj->NbFaces = (radius_faces-1) * (height_faces-1) * 2;
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<(height_faces-1);Cpt1++) // hauteur
	{
		for(Cpt2=0;Cpt2<(radius_faces-1);Cpt2++) // cercle
		{
			A = Cpt2 + radius_faces * Cpt1;
			B = Cpt2 + 1 + radius_faces * Cpt1;
			C = Cpt2 + 1 + radius_faces * (Cpt1+1);
			D = Cpt2 + radius_faces * (Cpt1+1);

			pObj->pFace[Cpt3].A = A;
			pObj->pFace[Cpt3].B = B;
			pObj->pFace[Cpt3].C = C;

			Cpt3++;

			pObj->pFace[Cpt3].A = C;
			pObj->pFace[Cpt3].B = D;
			pObj->pFace[Cpt3].C = A;

			Cpt3++;
		}
	}

	return pObj;
}

